<?php

namespace addons\feedback;

use app\common\library\Menu;
use think\Addons;

/**
 * 插件
 */
class Feedback extends Addons
{

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $menu = [
            [
                'name'    => 'feedback',
                'title'   => '意见反馈',
                'icon'    => 'fa fa-feed',
                'sublist' => [
                    ['name' => 'feedback/index', 'title' => '查看'],
                    ['name' => 'feedback/detail', 'title' => '详情'],
                    ['name' => 'feedback/del', 'title' => '删除'],
                ]
            ]
        ];
        Menu::create($menu);
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        Menu::delete('feedback');
        return true;
    }

    /**
     * 插件启用方法
     * @return bool
     */
    public function enable()
    {
        Menu::enable('feedback');
        return true;
    }

    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable()
    {
        Menu::disable('feedback');
        return true;
    }


}
